#include <EDK.h>
#include "General.h"

static char* apcRegister[] = {

  "PersonalC64", NULL,

  ".c64", NULL,
  ".c64", "C64Program",
  "C64Program", NULL,
  "C64Program", "C64 Program",
  "C64Program\\DefaultIcon", "%sPC64Win.exe,0",
  "C64Program\\shell\\open\\command", "%sPC64Win.exe %%1",

  ".p00", NULL,
  ".p00", "CBMData",
  ".s00", NULL,
  ".s00", "CBMData",
  ".u00", NULL,
  ".u00", "CBMData",
  ".d00", NULL,
  ".d00", "CBMData",
  ".r00", NULL,
  ".r00", "CBMData",
  "CBMData", NULL,
  "CBMData", "CBM Data File",
  "CBMData\\DefaultIcon", "%sPC64Win.exe,1",
  "CBMData\\shell\\open\\command", "%sPC64Win.exe %%1",

  ".d64", NULL,
  ".d64", "C64DiskImage",
  "C64DiskImage", NULL,
  "C64DiskImage", "C64 Disk Image",
  "C64DiskImage\\DefaultIcon", "%sPC64Win.exe,0",
  "C64DiskImage\\shell\\open\\command", "%sPC64Win.exe %%1",

  ".t64", NULL,
  ".t64", "C64TapeImage",
  "C64TapeImage", "C64 Tape Image",
  "C64TapeImage\\DefaultIcon", "%sPC64Win.exe,2",
  "C64TapeImage\\shell\\open\\command", "%sT64toP00.exe %%1",

  NULL
};

void Register() {
  char acDir[256];
  GetModuleFileName(NULL, acDir, sizeof acDir);
  strrchr(acDir, '\\')[1] = 0;
  // return if already registered
  char ac[256];
  LONG lSize = sizeof ac;
  if (RegQueryValue(HKEY_CLASSES_ROOT, "C64Program\\shell\\open\\command", ac, &lSize) == ERROR_SUCCESS) {
    if (_memicmp(ac, acDir, strlen(acDir)) == 0) {
      return;
    }
  }
  if (MessageBox(NULL, "Register C64 file extensions for the Windows Explorer?", "Personal C64", MB_ICONQUESTION | MB_OKCANCEL) != IDOK) {
    return;
  }
  // register classes
  for (char** ppc = apcRegister; *ppc != NULL; ppc += 2) {
    if (ppc[1] != NULL) {
      RegSetValue(HKEY_CLASSES_ROOT, ppc[0], REG_SZ, ac, sprintf(ac, ppc[1], acDir));
    } else {
      RegDeleteKey(HKEY_CLASSES_ROOT, ppc[0]);
    }
  }
  // set uninstall option
/*
  HKEY hk;
  RegCreateKey(HKEY_LOCAL_MACHINE, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\PersonalC64", &hk);
  RegSetValueEx(hk, "DisplayName", 0, REG_SZ, (BYTE*)ac, sprintf(ac, "Personal C64 " VERSION));
  RegSetValueEx(hk, "UninstallString", 0, REG_SZ, (BYTE*)ac, sprintf(ac, "%sPC64Win.exe /uninstall", acDir));
  RegCloseKey(hk);
*/
}
