#include <EDK.h>
#include <ddraw.h>
#include <dsetup.h>
#include <dsound.h>

void DDError(HRESULT hError, char* pcFunction, char* pcFile, int iLine) {
  char* pcMsg = NULL;
  switch (hError) {
  case DDERR_ALREADYINITIALIZED:
    pcMsg = "DDERR_ALREADYINITIALIZED\nThis object is already initialized";
    break;
  case DDERR_CANNOTATTACHSURFACE:
    pcMsg = "DDERR_CANNOTATTACHSURFACE\nThis surface can not be attached to the requested surface.";
    break;
  case DDERR_CANNOTDETACHSURFACE:
    pcMsg = "DDERR_CANNOTDETACHSURFACE\nThis surface can not be detached from the requested surface.";
    break;
  case DDERR_CURRENTLYNOTAVAIL:
    pcMsg = "DDERR_CURRENTLYNOTAVAIL\nSupport is currently not available.";
    break;
  case DDERR_EXCEPTION:
    pcMsg = "DDERR_EXCEPTION\nAn exception was encountered while performing the requested operation";
    break;
  case DDERR_GENERIC:
    pcMsg = "DDERR_GENERIC\nGeneric failure.";
    break;
  case DDERR_HEIGHTALIGN:
    pcMsg = "DDERR_HEIGHTALIGN\nHeight of rectangle provided is not a multiple of reqd alignment";
    break;
  case DDERR_INCOMPATIBLEPRIMARY:
    pcMsg = "DDERR_INCOMPATIBLEPRIMARY\nUnable to match primary surface creation request with existing primary surface.";
    break;
  case DDERR_INVALIDCAPS:
    pcMsg = "DDERR_INVALIDCAPS\nOne or more of the caps bits passed to the callback are incorrect.";
    break;
  case DDERR_INVALIDCLIPLIST:
    pcMsg = "DDERR_INVALIDCLIPLIST\nDirectDraw does not support provided Cliplist.";
    break;
  case DDERR_INVALIDMODE:
    pcMsg = "DDERR_INVALIDMODE\nDirectDraw does not support the requested mode";
    break;
  case DDERR_INVALIDOBJECT:
    pcMsg = "DDERR_INVALIDOBJECT\nDirectDraw received a pointer that was an invalid DIRECTDRAW object.";
    break;
  case DDERR_INVALIDPARAMS:
    pcMsg = "DDERR_INVALIDPARAMS\nOne or more of the parameters passed to the callback function are incorrect.";
    break;
  case DDERR_INVALIDPIXELFORMAT:
    pcMsg = "DDERR_INVALIDPIXELFORMAT\nPixel format was invalid as specified";
    break;
  case DDERR_INVALIDRECT:
    pcMsg = "DDERR_INVALIDRECT\nRectangle provided was invalid.";
    break;
  case DDERR_LOCKEDSURFACES:
    pcMsg = "DDERR_LOCKEDSURFACES\nOperation could not be carried out because one or more surfaces are locked";
    break;
  case DDERR_NO3D:
    pcMsg = "DDERR_NO3D\nThere is no 3D present.";
    break;
  case DDERR_NOALPHAHW:
    pcMsg = "DDERR_NOALPHAHW\nOperation could not be carried out because there is no alpha accleration hardware present or available.";
    break;
  case DDERR_NOCLIPLIST:
    pcMsg = " DDERR_NOCLIPLIST\nNo clip list available";
    break;
  case DDERR_NOCOLORCONVHW:
    pcMsg = "DDERR_NOCOLORCONVHW\nOperation could not be carried out because there is no color conversion hardware present or available.";
    break;
  case DDERR_NOCOOPERATIVELEVELSET:
    pcMsg = "DDERR_NOCOOPERATIVELEVELSET\nCreate function called without DirectDraw object method SetCooperativeLevel being called.";
    break;
  case DDERR_NOCOLORKEY:
    pcMsg = "DDERR_NOCOLORKEY\nSurface doesn't currently have a color key";
    break;
  case DDERR_NOCOLORKEYHW:
    pcMsg = "DDERR_NOCOLORKEYHW\nOperation could not be carried out because there is no hardware support of the dest color key.";
    break;
  case DDERR_NODIRECTDRAWSUPPORT:
    pcMsg = "DDERR_NODIRECTDRAWSUPPORT\nNo DirectDraw support possible with current display driver";
    break;
  case DDERR_NOEXCLUSIVEMODE:
    pcMsg = "DDERR_NOEXCLUSIVEMODE\nOperation requires the application to have exclusive mode but the application does not have exclusive mode.";
    break;
  case DDERR_NOFLIPHW:
    pcMsg = "DDERR_NOFLIPHW\nFlipping visible surfaces is not supported.";
    break;
  case DDERR_NOGDI:
    pcMsg = "DDERR_NOGDI\nThere is no GDI present.";
    break;
  case DDERR_NOMIRRORHW:
    pcMsg = "DDERR_NOMIRRORHW\nOperation could not be carried out because there is no hardware present or available.";
    break;
  case DDERR_NOTFOUND:
    pcMsg = "DDERR_NOTFOUND\nRequested item was not found";
    break;
  case DDERR_NOOVERLAYHW:
    pcMsg = "DDERR_NOOVERLAYHW\nOperation could not be carried out because there is no overlay hardware present or available.";
    break;
  case DDERR_NORASTEROPHW:
    pcMsg = "DDERR_NORASTEROPHW\nOperation could not be carried out because there is no appropriate raster op hardware present or available.";
    break;
  case DDERR_NOROTATIONHW:
    pcMsg = "DDERR_NOROTATIONHW\nOperation could not be carried out because there is no rotation hardware present or available.";
    break;
  case DDERR_NOSTRETCHHW:
    pcMsg = "DDERR_NOSTRETCHHW\nOperation could not be carried out because there is no hardware support for stretching";
    break;
  case DDERR_NOT4BITCOLOR:
    pcMsg = "DDERR_NOT4BITCOLOR\nDirectDrawSurface is not in 4 bit color palette and the requested operation requires 4 bit color palette.";
    break;
  case DDERR_NOT4BITCOLORINDEX:
    pcMsg = "DDERR_NOT4BITCOLORINDEX\nDirectDrawSurface is not in 4 bit color index palette and the requested operation requires 4 bit color index palette.";
    break;
  case DDERR_NOT8BITCOLOR:
    pcMsg = "DDERR_NOT8BITCOLOR\nDirectDraw Surface is not in 8 bit color mode and the requested operation requires 8 bit color.";
    break;
  case DDERR_NOTEXTUREHW:
    pcMsg = "DDERR_NOTEXTUREHW\nOperation could not be carried out because there is no texture mapping hardware present or available.";
    break;
  case DDERR_NOVSYNCHW:
    pcMsg = "DDERR_NOVSYNCHW\nOperation could not be carried out because there is no hardware support for vertical blank synchronized operations.";
    break;
  case DDERR_NOZBUFFERHW:
    pcMsg = "DDERR_NOZBUFFERHW\nOperation could not be carried out because there is no hardware support for zbuffer blting.";
    break;
  case DDERR_NOZOVERLAYHW:
    pcMsg = "DDERR_NOZOVERLAYHW\nOverlay surfaces could not be z layered based on their BltOrder because the hardware does not support z layering of overlays.";
    break;
  case DDERR_OUTOFCAPS:
    pcMsg = "DDERR_OUTOFCAPS\nThe hardware needed for the requested operation has already been allocated.";
    break;
  case DDERR_OUTOFMEMORY:
    pcMsg = "DDERR_OUTOFMEMORY\nDirectDraw does not have enough memory to perform the operation.";
    break;
  case DDERR_OUTOFVIDEOMEMORY:
    pcMsg = "DDERR_OUTOFVIDEOMEMORY\nDirectDraw does not have enough memory to perform the operation.";
    break;
  case DDERR_OVERLAYCANTCLIP:
    pcMsg = "DDERR_OVERLAYCANTCLIP\nHardware does not support clipped overlays.";
    break;
  case DDERR_OVERLAYCOLORKEYONLYONEACTIVE:
    pcMsg = "DDERR_OVERLAYCOLORKEYONLYONEACTIVE\nCan only have ony color key active at one time for overlays";
    break;
  case DDERR_PALETTEBUSY:
    pcMsg = "DDERR_PALETTEBUSY\nAccess to this palette is being refused because the palette is already locked by another thread.";
    break;
  case DDERR_COLORKEYNOTSET:
    pcMsg = "DDERR_COLORKEYNOTSET\nNo src color key specified for this operation.";
    break;
  case DDERR_SURFACEALREADYATTACHED:
    pcMsg = "DDERR_SURFACEALREADYATTACHED\nThis surface is already attached to the surface it is being attached to.";
    break;
  case DDERR_SURFACEALREADYDEPENDENT:
    pcMsg = "DDERR_SURFACEALREADYDEPENDENT\nThis surface is already a dependency of the surface it is being made a dependency of.";
    break;
  case DDERR_SURFACEBUSY:
    pcMsg = "DDERR_SURFACEBUSY\nAccess to this surface is being refused because the surface is already locked by another thread.";
    break;
  case DDERR_SURFACEISOBSCURED:
    pcMsg = "DDERR_SURFACEISOBSCURED\nAccess to Surface refused because Surface is obscured.";
    break;
  case DDERR_SURFACELOST:
    pcMsg = "DDERR_SURFACELOST\nAccess to this surface is being refused because the surface is gone. The DIRECTDRAWSURFACE object representing this surface should have Restore called on it.";
    break;
  case DDERR_SURFACENOTATTACHED:
    pcMsg = "DDERR_SURFACENOTATTACHED\nThe requested surface is not attached.";
    break;
  case DDERR_TOOBIGHEIGHT:
    pcMsg = "DDERR_TOOBIGHEIGHT\nHeight requested by DirectDraw is too large.";
    break;
  case DDERR_TOOBIGSIZE:
    pcMsg = "DDERR_TOOBIGSIZE\nSize requested by DirectDraw is too large\nThe individual height and width are OK.";
    break;
  case DDERR_TOOBIGWIDTH:
    pcMsg = "DDERR_TOOBIGWIDTH\nWidth requested by DirectDraw is too large.";
    break;
  case DDERR_UNSUPPORTED:
    pcMsg = "DDERR_UNSUPPORTED\nAction not supported.";
    break;
  case DDERR_UNSUPPORTEDFORMAT:
    pcMsg = "DDERR_UNSUPPORTEDFORMAT\nFOURCC format requested is unsupported by DirectDraw";
    break;
  case DDERR_UNSUPPORTEDMASK:
    pcMsg = "DDERR_UNSUPPORTEDMASK\nBitmask in the pixel format requested is unsupported by DirectDraw";
    break;
  case DDERR_VERTICALBLANKINPROGRESS:
    pcMsg = "DDERR_VERTICALBLANKINPROGRESS\nVertical blank is in progress";
    break;
  case DDERR_WASSTILLDRAWING:
    pcMsg = "DDERR_WASSTILLDRAWING\nInforms DirectDraw that the previous Blt which is transfering information to or from this Surface is incomplete.";
    break;
  case DDERR_XALIGN:
    pcMsg = "DDERR_XALIGN\nRectangle provided was not horizontally aligned on reqd. boundary";
    break;
  case DDERR_INVALIDDIRECTDRAWGUID:
    pcMsg = "DDERR_INVALIDDIRECTDRAWGUID\nThe GUID passed to DirectDrawCreate is not a valid DirectDraw driver identifier.";
    break;
  case DDERR_DIRECTDRAWALREADYCREATED:
    pcMsg = "DDERR_DIRECTDRAWALREADYCREATED\nA DirectDraw object representing this driver has already been created for this process.";
    break;
  case DDERR_NODIRECTDRAWHW:
    pcMsg = "DDERR_NODIRECTDRAWHW\nA hardware only DirectDraw object creation was attempted but the driver did not support any hardware.";
    break;
  case DDERR_PRIMARYSURFACEALREADYEXISTS:
    pcMsg = "DDERR_PRIMARYSURFACEALREADYEXISTS\nThis process already has created a primary surface";
    break;
  case DDERR_NOEMULATION:
    pcMsg = "DDERR_NOEMULATION\nSoftware emulation not available.";
    break;
  case DDERR_REGIONTOOSMALL:
    pcMsg = "DDERR_REGIONTOOSMALL\nRegion passed to Clipper::GetClipList is too small.";
    break;
  case DDERR_CLIPPERISUSINGHWND:
    pcMsg = "DDERR_CLIPPERISUSINGHWND\nAn attempt was made to set a clip list for a clipper objec that is already monitoring an hwnd.";
    break;
  case DDERR_NOCLIPPERATTACHED:
    pcMsg = "DDERR_NOCLIPPERATTACHED\nNo clipper object attached to surface object";
    break;
  case DDERR_NOHWND:
    pcMsg = "DDERR_NOHWND\nClipper notification requires an HWND or no HWND has previously been set as the CooperativeLevel HWND.";
    break;
  case DDERR_HWNDSUBCLASSED:
    pcMsg = "DDERR_HWNDSUBCLASSED\nHWND used by DirectDraw CooperativeLevel has been subclassed, this prevents DirectDraw from restoring state.";
    break;
  case DDERR_HWNDALREADYSET:
    pcMsg = "DDERR_HWNDALREADYSET\nThe CooperativeLevel HWND has already been set. It can not be reset while the process has surfaces or palettes created.";
    break;
  case DDERR_NOPALETTEATTACHED:
    pcMsg = "DDERR_NOPALETTEATTACHED\nNo palette object attached to this surface.";
    break;
  case DDERR_NOPALETTEHW:
    pcMsg = "DDERR_NOPALETTEHW\nNo hardware support for 16 or 256 color palettes.";
    break;
  case DDERR_BLTFASTCANTCLIP:
    pcMsg = "DDERR_BLTFASTCANTCLIP\nIf a clipper object is attached to the source surface passed into a BltFast call.";
    break;
  case DDERR_NOBLTHW:
    pcMsg = "DDERR_NOBLTHW\nNo blter.";
    break;
  case DDERR_NODDROPSHW:
    pcMsg = "DDERR_NODDROPSHW\nNo DirectDraw ROP hardware.";
    break;
  case DDERR_OVERLAYNOTVISIBLE:
    pcMsg = "DDERR_OVERLAYNOTVISIBLE\nGetOverlayPosition is called on a hidden overlay";
    break;
  case DDERR_NOOVERLAYDEST:
    pcMsg = "DDERR_NOOVERLAYDEST\nGetOverlayPosition is called on a overlay that UpdateOverlay has never been called on to establish a destionation.";
    break;
  case DDERR_INVALIDPOSITION:
    pcMsg = "DDERR_INVALIDPOSITION\nThe position of the overlay on the destionation is no longer legal for that destionation.";
    break;
  case DDERR_NOTAOVERLAYSURFACE:
    pcMsg = "DDERR_NOTAOVERLAYSURFACE\nAn overlay member is called for a non -overlay surface";
    break;
  case DDERR_EXCLUSIVEMODEALREADYSET:
    pcMsg = "DDERR_EXCLUSIVEMODEALREADYSET\nAn attempt was made to set the cooperative level when it was already set to exclusive.";
    break;
  case DDERR_NOTFLIPPABLE:
    pcMsg = "DDERR_NOTFLIPPABLE\nAn attempt has been made to flip a surface that is not flippable.";
    break;
  case DDERR_CANTDUPLICATE:
    pcMsg = "DDERR_CANTDUPLICATE\nCan't duplicate primary & 3D surfaces, or surfaces that are implicitly created.";
    break;
  case DDERR_NOTLOCKED:
    pcMsg = "DDERR_NOTLOCKED\nSurface was not locked.  An attempt to unlock a surface that was not locked at all, or by this process, has been attempted.";
    break;
  case DDERR_CANTCREATEDC:
    pcMsg = "DDERR_CANTCREATEDC\nWindows can not create any more DCs";
    break;
  case DDERR_NODC:
    pcMsg = "DDERR_NODC\nNo DC was ever created for this surface.";
    break;
  case DDERR_WRONGMODE:
    pcMsg = "DDERR_WRONGMODE\nThis surface can not be restored because it was created in a different mode.";
    break;
  case DDERR_IMPLICITLYCREATED:
    pcMsg = "DDERR_IMPLICITLYCREATED\nThis surface can not be restored because it is an implicitly created surface.";
    break;
  case DDERR_NOTPALETTIZED:
    pcMsg = "DDERR_NOTPALETTIZED\nThe surface being used is not a palette-based surface";
    break;
  case DSETUPERR_BADWINDOWSVERSION:
    pcMsg = "DSETUPERR_BADWINDOWSVERSION\nThe version of Windows on the user's system is not supported by DirectX.";
    break;
  case DSETUPERR_SOURCEFILENOTFOUND:
    pcMsg = "DSETUPERR_SOURCEFILENOTFOUND\nOne of the required source files could not be found.";
    break;
  case DSETUPERR_BADSOURCESIZE:
    pcMsg = "DSETUPERR_BADSOURCESIZE\nA file's size could not be verified or was incorrect.";
    break;
  case DSETUPERR_BADSOURCETIME:
    pcMsg = "DSETUPERR_BADSOURCETIME\nA file's date and time could not be verified or was incorrect.";
    break;
  case DSETUPERR_NOCOPY:
    pcMsg = "DSETUPERR_NOCOPY\nA file's version could not be verified or was incorrect. If the DSETUP_REINSTALL flag is specified, equal versions will be installed..";
    break;
  case DSETUPERR_CANTFINDINF:
    pcMsg = "DSETUPERR_CANTFINDINF\nA required INF file could not be found.";
    break;
  case DSETUPERR_OUTOFDISKSPACE:
    pcMsg = "DSETUPERR_OUTOFDISKSPACE\nSetup ran out of disk space during the installation.";
    break;
  case DSETUPERR_CANTFINDDIR:
    pcMsg = "DSETUPERR_CANTFINDDIR\nSetup could not find the working directory.";
    break;
  case DSETUPERR_INTERNAL:
    pcMsg = "DSETUPERR_INTERNAL\nInternal error.";
    break;
  default:
    error("%s\nfailed in file %s at line %d\nUnknown DirectDraw error %d", pcFunction, pcFile, iLine, hError);
  }
  error("%s\nfailed in file %s at line %d\n%s", pcFunction, pcFile, iLine, pcMsg);
}
