#ifndef CVIA6522_h
#define CVIA6522_h

#include "CPort.h"
#include "CLine.h"

class CVIA6522 : public Chip {
public:

  CPort PA;             // bidirectional ports with open collector outputs
  CPort PB;
  byte bPALatch;        // buffered output values
  byte bPBLatch;
  byte bDDRA;           // 8 bits: 0 = input, 1 = output
  byte bDDRB;
  CLine CA1;            // port control lines
  CLine CA2;
  CLine CB1;
  CLine CB2;
  byte bPCR;            // port control register
  byte abPortFill[3];

  Timer T1;             // functions for timer underflows
  void OnT1Underflow();
  Timer T2;
  void OnT2Underflow();
  int iT1End;           // iT1End - GetClocks = timer values for reads
  int iT2End;
  int iT1Latch;         // start values
  int iT2Latch;
  byte bACR;            // auxiliary control register
  byte abTimerFill[3];

  CLine Int;
  byte bIFR;            // interrupt flag register
  byte bIER;            // interrupt enable register
  byte abIntFill[2];

  CLine Reset;

  global CVIA6522();
  virtual ~CVIA6522();

};

#endif
