#ifndef CKeyboard_h
#define CKeyboard_h

#include "CPort.h"
#include "CLine.h"

class CKeyboard : public Object {
public:
  CPort KeyRow;
  void KeyOnRowChange(byte bState, byte bChanges);
  CPort KeyCol;
  void KeyOnColChange(byte bState, byte bChanges);
  CLine Restore;
  CLine Reset;
  CPort Joystick;
  CPort SecondJoystick;
  byte abMatrix[16];
  byte gabKeyState[512];
  byte gabC64Keys[256];
  char* gpcTextIn;
  char* gpcTextEnd;
  char* gpcTextOut;
  byte* gpbOut;
  byte* gpbKeyMapping;

  byte gbC64In;
  byte gbC64Out;
  byte bShiftLock;
  byte bStopEmulation;

  CKeyboard();
  virtual ~CKeyboard();
  void ClearKeys();
  void C64Key(WPARAM wParam, LPARAM lParam);
  void SetKeyMatrix();
  void ReadKeyMapping();
  byte* AddC64Keys(byte* pb);
  void Parse();
  void GetC64Keys();
  flag Find(char** ppcText, int iCount);
  void Insert(char* pcText);
  void SkipSpace(flag fSkipComment = FALSE);
  char GetChar();
};

#endif
