#ifndef CHarddisk_h
#define CHarddisk_h

#include "CIECDevice.h"
#include "CC64File.h"

enum EState {
  eIdle, eListen, eCommand, eOpen, eReceive, eTalk, eError, eClose, eSend
};

class CHarddisk : public CIECDevice {
public:
  int iCh;
  EState eState;
  char acCommand[80];
  int iIn;
  char acError[80];
  int iOut;
  CString Dir;
  CC64File aCh[15];

  int Load(CString Name, byte* pbBuffer, int iSize);

  DeviceType GetType();
  CString GetDisk();
  void SetDisk(const CString& NewDisk);

  void SetError(const char* pcError);
  void Command();

  CHarddisk();
  virtual ~CHarddisk();
};

#endif
