#ifndef CFDC325572_h
#define CFDC325572_h

#include "CLine.h"
#include "CPort.h"
#include "CMsg.h"

class CFDC325572 : public Chip {
public:

  CLine MTR;            // high = motor on
  CPort Step;           // binary increment/decrement to move head
  void OnStep(byte bState, byte bChanges);
  int iTrack;           // current track from 1 to 35+
  byte bStep;           // bits 0 and 1 from stepper motor
  byte abStepFill[3];

  CString Disk;         // current disk image or ""
  HANDLE hFile;
  flag fReadOnly;

  byte* pbGCRStart;     // buffer with GCR data, encoded on the fly
  byte* pbData;         // read/write pointer into GCR
  byte* pbGCREnd;       // for pbData wrap around
  Timer NextByte;       // function to increment pbData for next byte
  void OnReadNextByte();
  void OnWriteNextByte();
  CMsg Clocks;          // system clocks between bytes 26/28/30/32
  int iClocks;
  flag fDirty;          // new data has been written to current track

  CLine OE;             // output enable, high = read, low = write
  CLine SOE;            // what the hell is this, default = high?
  CLine ByteReady;      // low for one cycle = byte has been read/written
  CLine Sync;           // low = GCR data $FFFF occured

  CPort Data;           // data byte
  byte bID1;            // ID from D64 images for GCR header
  byte bID2;
  byte bLastByte;       // last byte read for SYNC recognization
  byte abIDFill[1];

  byte* SectorToGCR(byte* pbGCR, byte* pbData, int iSector);
  void ReadTrack();
  byte* FindEndOfNextSync(byte* pbGCR);
  void WriteTrack();
  CString GetDisk();
  void SetDisk(const CString NewDisk);

  CFDC325572();
  virtual ~CFDC325572();
};

#endif
