#ifndef CDisplay_h
#define CDisplay_h

#include "CKeyboard.h"

class CDisplay : public Object {
public:

  HWND hwnd;            // display window
  CKeyboard* pKeyboard; // because of common WndProc

  int iFrames;          // total frame counter for current second
  int iDisplayedFrames; // visible frame counter for current second
  int iMinFrames;       // lowest allowed fps rate
  int iMinFramesSum;    // Bresenham counter, display frame if < 0
  flag fDisplayFrame;   // fals = skip the next frame to get more speed

  int iClocksPer50Frames;
  int iLastClocks;      // saved LowWord of QueryPerformanceCounter
  int iLastPercent;     // for recognizing changes in window title
  int iLastDisplayedFrames;

  CDisplay::CDisplay();
  virtual ~CDisplay();
  flag Refresh();
};

#endif
