////////////////////////////////////////////////////////////////////////////////
// Win32/Config.h -- this file is part of the Emulator Developers Kit
// available at http://ourworld.compuserve.com/homepages/pc64/develop.htm


class ConfigBase {
public:
  virtual void SetInt(const char* pcSection, const char* pcKey, int iValue) = 0;
  virtual int GetInt(const char* pcSection, const char* pcKey, int iDefault) = 0;
  virtual void SetString(const char* pcSection, const char* pcKey, const char* pcValue) = 0;
  virtual void GetString(const char* pcSection, const char* pcKey, char* pcBuffer, int iSize, const char* pcDefault) = 0;
};

class Config {
  ConfigBase* pConfig;
public:

  // constructor
  global Config(const char* pcProgram, const char* pcIni);

  // destructor
  virtual ~Config();

  // interface
  inline void SetInt(const char* pcSection, const char* pcKey, int iValue)                         { pConfig->SetInt(pcSection, pcKey, iValue); }
  inline int GetInt(const char* pcSection, const char* pcKey, int iDefault)                        { return pConfig->GetInt(pcSection, pcKey, iDefault); }
  inline void GetString(const char* pcSection, const char* pcKey, char* pcBuffer, int iSize, const char* pcDefault) { pConfig->GetString(pcSection, pcKey, pcBuffer, iSize, pcDefault); }
  inline void SetString(const char* pcSection, const char* pcKey, const char* pcValue)             { pConfig->SetString(pcSection, pcKey, pcValue); }
};


// declare global variable for DLL linkage
#if defined(Toolbox_cpp)
  extern Config gconf;
  #if defined(ExportToolbox)
    __declspec(dllexport) Config* gpconf = &gconf;
  #endif
#elif defined(ImportToolbox)
  __declspec(dllimport) Config* gpconf;
  static Config& gconf = *gpconf;
#else
  extern Config gconf;
#endif
