////////////////////////////////////////////////////////////////////////////////
// CPU6510C64.h -- this file is part of the Emulator Developers Kit
// available at http://ourworld.compuserve.com/homepages/pc64/develop.htm
//
// You must CPU.MapChip(&CPU, pbRam, 2) from outside! The CPU6510C64
// cannot map the registers $00/$01 itself because page 0 could be
// memory mapped.

class CPU6510C64 : public CPU65xx {

  byte bDDR;            // direction register at $00
  byte bLatch;          // data output latch at $01
  byte bHighInputs;     // for bits 3, 6 and 7
  byte abPortFill[1];

  Timer DrawLowBit3;
  Timer DrawLowBit6;
  Timer DrawLowBit7;
  void OnDrawLowBit3();
  void OnDrawLowBit6();
  void OnDrawLowBit7();

  // update port after bDDR or bLatch have changed
  void UpdatePort(byte bNewDDR, byte bNewLatch);

  // reset also the port when the reset line goes low
  void OnResetLow();

  // port access functions
  byte ReadDDR();
  void WriteDDR(byte bValue);
  byte ReadPR();
  void WritePR(byte bValue);

protected:

  // initialisation
  virtual void DoInit();

public:

  // constructor
  global CPU6510C64() {
    static const Register aRegs[2] = {
      (bpfn)ReadDDR, (pfnb)WriteDDR, 0,
      (bpfn)ReadPR, (pfnb)WritePR, 0
    };
    pRegisters = aRegs;
    iRegisterCount = 2;
    bDDR = 0;
    bLatch = 0;
    bHighInputs = 0;
  }

  // 6 bit port at $00/$01
  Port P;

};
