/***************************************************************************
 *                                                                         *
 *    LIBDSK: General floppy and diskimage access library                  *
 *    Copyright (C) 2002  John Elliott <jce@seasip.demon.co.uk>            *
 *                                                                         *
 *    This library is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU Library General Public          *
 *    License as published by the Free Software Foundation; either         *
 *    version 2 of the License, or (at your option) any later version.     *
 *                                                                         *
 *    This library is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    *
 *    Library General Public License for more details.                     *
 *                                                                         *
 *    You should have received a copy of the GNU Library General Public    *
 *    License along with this library; if not, write to the Free           *
 *    Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,      *
 *    MA 02111-1307, USA                                                   *
 *                                                                         *
 ***************************************************************************/

/* RPC functions: client side.
 *
 * The only functions I've implemented are those needed by drvwin32.c */

#include "drvi.h"
#include "rpcfuncs.h"

dsk_err_t dsk_r_open(DSK_PDRIVER self, RPCFUNC func, unsigned int *nDriver, const char *filename, const char *type, const char *comp)
{
	unsigned char ibuf[PATH_MAX + 100], *iptr = ibuf;
	unsigned char obuf[20]            , *optr = obuf;
	dsk_err_t err;
	int ilen = sizeof ibuf;
	int olen = sizeof obuf;
	int32 nd;
	dsk_err_t err2;

	err = dsk_pack_i16   (&iptr, &ilen, RPC_DSK_OPEN); if (err) return err;
	err = dsk_pack_string(&iptr, &ilen, filename);	   if (err) return err;
	err = dsk_pack_string(&iptr, &ilen, type);	   if (err) return err;
	err = dsk_pack_string(&iptr, &ilen, comp);	   if (err) return err;
	err = (*func)(self, ibuf, iptr - ibuf, obuf, &olen); if (err) return err;
	err = dsk_unpack_err  (&optr, &olen, &err2);	   if (err) return err;
	err = dsk_unpack_i32  (&optr, &olen, &nd);		   if (err) return err;
	*nDriver = (unsigned int)nd;
	return err2;
}


dsk_err_t dsk_r_creat(DSK_PDRIVER self,RPCFUNC func, unsigned int *nDriver, const char *filename, const char *type, const char *comp)
{
	unsigned char ibuf[PATH_MAX + 100], *iptr = ibuf;
	unsigned char obuf[20]            , *optr = obuf;
	dsk_err_t err;
	int ilen = sizeof ibuf;
	int olen = sizeof obuf;
	int32 nd;
	dsk_err_t err2;

	err = dsk_pack_i16   (&iptr, &ilen, RPC_DSK_CREAT); if (err) return err;
	err = dsk_pack_string(&iptr, &ilen, filename);	    if (err) return err;
	err = dsk_pack_string(&iptr, &ilen, type);	    if (err) return err;
	err = dsk_pack_string(&iptr, &ilen, comp);	    if (err) return err;
	err = (*func)(self, ibuf, iptr - ibuf, obuf, &olen);if (err) return err;
	err = dsk_unpack_err  (&optr, &olen, &err2);	    if (err) return err;
	err = dsk_unpack_i32  (&optr, &olen, &nd);	    if (err) return err;
	*nDriver = (unsigned int)nd;
	return err2;
}



dsk_err_t dsk_r_close(DSK_PDRIVER self, RPCFUNC func, unsigned int nDriver)
{
	unsigned char ibuf[20], *iptr = ibuf;
	unsigned char obuf[20], *optr = obuf;
	dsk_err_t err;
	int ilen = sizeof ibuf;
	int olen = sizeof obuf;
	dsk_err_t err2;

	err = dsk_pack_i16   (&iptr, &ilen, RPC_DSK_CLOSE);if (err) return err;
	err = dsk_pack_i32   (&iptr, &ilen, nDriver);  if (err) return err;
	err = (*func)(self, ibuf, iptr - ibuf, obuf, &olen); if (err) return err;
	err = dsk_unpack_err  (&optr, &olen, &err2);	   if (err) return err;
	return err2;
}



dsk_err_t dsk_r_read (DSK_PDRIVER self, RPCFUNC func, unsigned int nDriver, const DSK_GEOMETRY *geom, void *buf, dsk_pcyl_t cylinder,
                              dsk_phead_t head, dsk_psect_t sector)
	{
	unsigned char ibuf[200], *iptr = ibuf;
	unsigned char obuf[9000], *optr = obuf;
	dsk_err_t err;
	int ilen = sizeof ibuf;
	int olen = sizeof obuf;
	dsk_err_t err2;
	unsigned char *buf2;

	err = dsk_pack_i16   (&iptr, &ilen, RPC_DSK_PREAD);if (err) return err;
	err = dsk_pack_i32   (&iptr, &ilen, nDriver);  if (err) return err;
	err = dsk_pack_geom  (&iptr, &ilen, geom);	   if (err) return err;
	err = dsk_pack_i32   (&iptr, &ilen, cylinder);     if (err) return err;
	err = dsk_pack_i32   (&iptr, &ilen, head);         if (err) return err;
	err = dsk_pack_i32   (&iptr, &ilen, sector);       if (err) return err;
	err = (*func)(self, ibuf, iptr - ibuf, obuf, &olen);	   if (err) return err;
	err = dsk_unpack_err  (&optr, &olen, &err2);	   if (err) return err;
	err = dsk_unpack_bytes(&optr, &olen, &buf2);	   if (err) return err;
	memcpy(buf, buf2, geom->dg_secsize);
	return err2;
	}


dsk_err_t dsk_r_secid(DSK_PDRIVER self, RPCFUNC func, unsigned int nDriver, const DSK_GEOMETRY *geom, dsk_pcyl_t cylinder, 
					  dsk_phead_t head, DSK_FORMAT *result)
	{
	unsigned char ibuf[200], *iptr = ibuf;
	unsigned char obuf[200], *optr = obuf;
	dsk_err_t err;
	int ilen = sizeof ibuf;
	int olen = sizeof obuf;
	dsk_err_t err2;

	err = dsk_pack_i16   (&iptr, &ilen, RPC_DSK_PSECID);if (err) return err;
	err = dsk_pack_i32   (&iptr, &ilen, nDriver);  if (err) return err;
	err = dsk_pack_geom  (&iptr, &ilen, geom);	   if (err) return err;
	err = dsk_pack_i32   (&iptr, &ilen, cylinder);     if (err) return err;
	err = dsk_pack_i32   (&iptr, &ilen, head);         if (err) return err;
	err = (*func)(self, ibuf, iptr - ibuf, obuf, &olen);   if (err) return err;
	err = dsk_unpack_err  (&optr, &olen, &err2);	   if (err) return err;
	err = dsk_unpack_format(&optr, &olen, result);	   if (err) return err;
	return err2;
	}




dsk_err_t dsk_r_write(DSK_PDRIVER self, RPCFUNC func, unsigned int nDriver, const DSK_GEOMETRY *geom, const void *buf, dsk_pcyl_t cylinder,
					  dsk_phead_t head, dsk_psect_t sector)
	{
	unsigned char ibuf[9000], *iptr = ibuf;
	unsigned char obuf[200], *optr = obuf;
	dsk_err_t err;
	int ilen = sizeof ibuf;
	int olen = sizeof obuf;
	dsk_err_t err2;

	err = dsk_pack_i16   (&iptr, &ilen, RPC_DSK_PWRITE);if (err) return err;
	err = dsk_pack_i32   (&iptr, &ilen, nDriver);	   if (err) return err;
	err = dsk_pack_geom  (&iptr, &ilen, geom);		   if (err) return err;
	err = dsk_pack_bytes (&iptr, &ilen, buf, geom->dg_secsize); if (err) return err;
	err = dsk_pack_i32   (&iptr, &ilen, cylinder);     if (err) return err;
	err = dsk_pack_i32   (&iptr, &ilen, head);         if (err) return err;
	err = dsk_pack_i32   (&iptr, &ilen, sector);      if (err) return err;
	err = (*func)(self, ibuf, iptr - ibuf, obuf, &olen);	   if (err) return err;
	err = dsk_unpack_err  (&optr, &olen, &err2);	   if (err) return err;
	return err2;
	}


dsk_err_t dsk_r_format(DSK_PDRIVER self, RPCFUNC func, unsigned int nDriver, DSK_GEOMETRY *geom, dsk_pcyl_t cylinder, 
					  dsk_phead_t head, const DSK_FORMAT *format, unsigned char filler)
	{
	unsigned char ibuf[300], *iptr = ibuf;
	unsigned char obuf[200], *optr = obuf;
	dsk_err_t err;
	int ilen = sizeof ibuf;
	int olen = sizeof obuf;
	dsk_err_t err2;
	unsigned int n;

	err = dsk_pack_i16   (&iptr, &ilen, RPC_DSK_PFORMAT);if (err) return err;
	err = dsk_pack_i32   (&iptr, &ilen, nDriver);	   if (err) return err;
	err = dsk_pack_geom  (&iptr, &ilen, geom);		   if (err) return err;
	err = dsk_pack_i32   (&iptr, &ilen, cylinder);     if (err) return err;
	err = dsk_pack_i32   (&iptr, &ilen, head);         if (err) return err;
	for (n = 0; n < geom->dg_sectors; n++)
		{
		err = dsk_pack_format(&iptr, &ilen, &format[n]); if (err) return err;
		}
	err = dsk_pack_i16   (&iptr, &ilen, filler);	   if (err) return err;
	err = (*func)(self, ibuf, iptr - ibuf, obuf, &olen);	   if (err) return err;
	err = dsk_unpack_err  (&optr, &olen, &err2);	   if (err) return err;
	err = dsk_unpack_geom (&optr, &olen, geom);		   if (err) return err;
	return err2;
	}


dsk_err_t dsk_r_drive_status(DSK_PDRIVER self, RPCFUNC func, unsigned int nDriver, const DSK_GEOMETRY *geom,
					  dsk_phead_t head, unsigned char *result)
	{
	unsigned char ibuf[200], *iptr = ibuf;
	unsigned char obuf[200], *optr = obuf;
	dsk_err_t err;
	int ilen = sizeof ibuf;
	int olen = sizeof obuf;
	dsk_err_t err2;
	int16 i;

	err = dsk_pack_i16   (&iptr, &ilen, RPC_DSK_PFORMAT);if (err) return err;
	err = dsk_pack_i32   (&iptr, &ilen, nDriver);	   if (err) return err;
	err = dsk_pack_geom  (&iptr, &ilen, geom);		   if (err) return err;
	err = dsk_pack_i32   (&iptr, &ilen, head);         if (err) return err;
	err = (*func)(self, ibuf, iptr - ibuf, obuf, &olen);	   if (err) return err;
	err = dsk_unpack_err  (&optr, &olen, &err2);	   if (err) return err;
	err = dsk_unpack_i16  (&optr, &olen, &i); 	   if (err) return err;
	*result = (unsigned char)i;
	return DSK_ERR_OK;
	}

